import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viserpay_merchant/core/utils/app_dialog.dart';
import 'package:viserpay_merchant/data/model/invoice/invoice_history_response_model.dart';
import 'package:viserpay_merchant/view/components/text-form-field/custom_text_field.dart';
import 'package:viserpay_merchant/view/components/text/bottom_sheet_header_text.dart';

import '../../../../core/utils/dimensions.dart';
import '../../../../core/utils/my_color.dart';
import '../../../../core/utils/my_strings.dart';
import '../../../../core/utils/style.dart';
import '../../../../data/controller/invoice/update_invoice_controller.dart';
import '../../../../data/repo/invoice/update_invoice_repo.dart';
import '../../../../data/services/api_service.dart';
import '../../../components/app-bar/action_button_icon_widget.dart';
import '../../../components/app-bar/custom_appbar.dart';
import '../../../components/buttons/rounded_button.dart';
import '../../../components/custom_loader/custom_loader.dart';
import 'widget/update_invoice_items.dart';

class UpdateInvoiceScreen extends StatefulWidget {
  const UpdateInvoiceScreen({
    super.key,
    required this.paymentCharge,
  });
  final PaymentCharge paymentCharge;
  @override
  State<UpdateInvoiceScreen> createState() => _UpdateInvoiceScreenState();
}

class _UpdateInvoiceScreenState extends State<UpdateInvoiceScreen> {
  late String invoiceNumber;

  final formKey = GlobalKey<FormState>();

  @override
  void initState() {
    Get.put(ApiClient(sharedPreferences: Get.find()));
    Get.put(UpdateInvoiceRepo(apiClient: Get.find()));
    final controller = Get.put(UpdateInvoiceController(updateInvoiceRepo: Get.find()));
    super.initState();

    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      invoiceNumber = Get.arguments[0].toString();

      controller.loadData(
        invoiceNum: invoiceNumber,
        paymentCharge:widget.paymentCharge,
      );
    });
  }

  @override
  void dispose() {
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return GetBuilder<UpdateInvoiceController>(
      builder: (controller) => Scaffold(
        backgroundColor: MyColor.getScreenBgColor(),
        appBar: CustomAppBar(
          title: "${MyStrings.edit} ${MyStrings.invoice}",
          elevation: 0.1,
          action: [
            ActionButtonIconWidget(
              icon: Icons.cancel_outlined,
              isLoading: controller.isDiscardInvoiceLoading,
              pressed: () {
                AppDialog().invoiceCancelDialog(context, onPressYes: (v) {
                  controller.cancelInvoice(v);
                });
              },
            ),
          ],
        ),
        body: controller.isLoading
            ? const CustomLoader()
            : SingleChildScrollView(
                padding: const EdgeInsets.symmetric(vertical: Dimensions.space20, horizontal: Dimensions.space15),
                child: Form(
                  key: formKey,
                  child: Column(crossAxisAlignment: CrossAxisAlignment.start, children: [
                    Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Text(
                          MyStrings.invoiceItems.tr,
                          style: boldOverLarge.copyWith(
                            color: MyColor.getTextColor(),
                            fontWeight: FontWeight.bold, // Makes title bold
                          ),
                        ),
                        const SizedBox(height: Dimensions.space20),
                        ListView.separated(
                          shrinkWrap: true,
                          scrollDirection: Axis.vertical,
                          physics: const NeverScrollableScrollPhysics(),
                          itemCount: controller.invoiceItemList.length,
                          separatorBuilder: (context, index) => const SizedBox(height: Dimensions.space15),
                          itemBuilder: (context, index) {
                            return index == 0
                                ? Row(
                                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                    crossAxisAlignment: CrossAxisAlignment.end,
                                    children: [
                                      Expanded(
                                        child: CustomTextField(
                                          needOutlineBorder: true,
                                          labelText: MyStrings.itemName.tr,
                                          controller: controller.invoiceItemList[index].itemNameController,
                                          onChanged: (value) {},
                                          validator: (value) {
                                            if (value!.isEmpty) {
                                              return MyStrings.plsFillOutFieldMsg.tr;
                                            } else {
                                              return null;
                                            }
                                          },
                                        ),
                                      ),
                                      const SizedBox(width: Dimensions.space10),
                                      Expanded(
                                        child: CustomTextField(
                                            needOutlineBorder: true,
                                            labelText: MyStrings.amount.tr,
                                            textInputType: TextInputType.number,
                                            controller: controller.invoiceItemList[index].amountController,
                                            validator: (value) {
                                              if (value!.isEmpty) {
                                                return MyStrings.plsFillOutFieldMsg.tr;
                                              } else {
                                                return null;
                                              }
                                            },
                                            onChanged: (value) {
                                              controller.calculateInvoiceAmount();
                                            }),
                                      ),
                                    ],
                                  )
                                : Row(
                                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                    crossAxisAlignment: CrossAxisAlignment.center,
                                    children: [
                                      Expanded(
                                        child: CustomTextField(
                                          needOutlineBorder: true,
                                          labelText: MyStrings.itemName.tr,
                                          controller: controller.invoiceItemList[index].itemNameController,
                                          onChanged: (value) {},
                                          validator: (value) {
                                            if (value!.isEmpty) {
                                              return MyStrings.plsFillOutFieldMsg.tr;
                                            } else {
                                              return null;
                                            }
                                          },
                                        ),
                                      ),
                                      const SizedBox(width: Dimensions.space10),
                                      Expanded(
                                        child: CustomTextField(
                                            needOutlineBorder: true,
                                            labelText: MyStrings.amount.tr,
                                            textInputType: TextInputType.number,
                                            controller: controller.invoiceItemList[index].amountController,
                                            validator: (value) {
                                              if (value!.isEmpty) {
                                                return MyStrings.plsFillOutFieldMsg.tr;
                                              } else {
                                                return null;
                                              }
                                            },
                                            onChanged: (value) {
                                              controller.calculateInvoiceAmount();
                                            }),
                                      ),
                                      const SizedBox(width: Dimensions.space10),
                                      GestureDetector(
                                        onTap: () {
                                          controller.decreaseNumberField(index);
                                        },
                                        child: Container(
                                          padding: const EdgeInsets.all(Dimensions.space5),
                                          margin: const EdgeInsets.only(top: Dimensions.space10),
                                          alignment: Alignment.center,
                                          decoration: BoxDecoration(color: MyColor.colorRed, borderRadius: BorderRadius.circular(Dimensions.space5)),
                                          child: const Icon(Icons.clear, color: MyColor.colorWhite, size: 25),
                                        ),
                                      )
                                    ],
                                  );
                          },
                        ),
                        const SizedBox(height: Dimensions.space20),
                        GestureDetector(
                          onTap: () => controller.increaseNumberField(),
                          child: Row(
                            children: [const Icon(Icons.add, color: MyColor.primaryColor, size: 20), const SizedBox(width: Dimensions.space10), Text(MyStrings.addItems.tr, style: regularDefault.copyWith(color: MyColor.primaryColor))],
                          ),
                        ),
                        const SizedBox(height: Dimensions.space20),
                        Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          Padding(
                            padding: const EdgeInsets.symmetric(vertical: Dimensions.space5),
                            child: RichText(
                              text: TextSpan(
                                children: [
                                  TextSpan(
                                    text: "${MyStrings.totalAmount.tr}: ",
                                    style: regularDefault.copyWith(
                                      fontWeight: FontWeight.bold,
                                      color: MyColor.colorGrey,
                                    ),
                                  ),
                                  TextSpan(
                                    text: "${Get.find<ApiClient>().getCurrencyOrUsername(isSymbol: true)}${controller.totalInvoiceAmount}",
                                    style: regularDefault.copyWith(
                                      color: MyColor.getTextColor(),
                                    ),
                                  ),
                                ],
                              ),
                            ),
                          ),
                          Padding(
                            padding: const EdgeInsets.symmetric(vertical: Dimensions.space5),
                            child: RichText(
                              text: TextSpan(
                                children: [
                                  TextSpan(
                                    text: "${MyStrings.charge.tr}: ",
                                    style: regularDefault.copyWith(
                                      fontWeight: FontWeight.bold,
                                      color: MyColor.colorGrey,
                                    ),
                                  ),
                                  TextSpan(
                                    text: "${Get.find<ApiClient>().getCurrencyOrUsername(isSymbol: true)}${controller.charge}",
                                    style: regularDefault.copyWith(
                                      color: MyColor.getTextColor(),
                                    ),
                                  ),
                                ],
                              ),
                            ),
                          ),
                          Padding(
                            padding: const EdgeInsets.symmetric(vertical: Dimensions.space5),
                            child: RichText(
                              text: TextSpan(
                                children: [
                                  TextSpan(
                                    text: "${MyStrings.getAmount.tr}: ",
                                    style: regularDefault.copyWith(
                                      fontWeight: FontWeight.bold,
                                      color: MyColor.colorGrey,
                                    ),
                                  ),
                                  TextSpan(
                                    text: "${Get.find<ApiClient>().getCurrencyOrUsername(isSymbol: true)}${controller.getableText}",
                                    style: regularDefault.copyWith(
                                      color: MyColor.getTextColor(),
                                    ),
                                  ),
                                ],
                              ),
                            ),
                          ),
                        ],
                      ),
                        const SizedBox(height: Dimensions.space25),
                        RoundedButton(
                          press: () {
                            if (formKey.currentState!.validate()) {
                              controller.submitUpdateInvoice();
                            }
                          },
                          text: MyStrings.updateInvoice.tr,
                        )
                      ],
                    ),
                  ]),
                ),
              ),
      ),
    );
  }
}
